﻿const string justificationAlias = "ExJustification";
const string commentAlias = "Comment";

const string fileCategoryName = "Финансовое обоснование";
const string fileIDContentSourcesAlias = "FileIDContentSources";

var dCard = await this.GetNewCardAsync();
var mCard = await this.GetCardObjectAsync();

dCard.ID = Guid.NewGuid();
dCard.Sections[justificationAlias].Fields[commentAlias] = mCard.Sections[justificationAlias].Fields[commentAlias];

mCard.Files.RemoveAll(i => !string.Equals(i.CategoryCaption, fileCategoryName, StringComparison.Ordinal));

var result = await CardHelper.CopyFilesAsync(
	mCard,
	dCard,
	this.UnityContainer,
	cancellationToken: this.CancellationToken);
this.ValidationResult.Add(result);

if(result.HasErrors)
{
	return; 
}

var dCardFiles = dCard.Files;

// Сохранение информации о внешнем источнике контента файла.
var fileIDContentSources = new Dictionary<string, object>(dCardFiles.Count, StringComparer.Ordinal);
foreach(var dCardFile in dCardFiles)
{
	fileIDContentSources.Add(dCardFile.RowID.ToString("N"), dCardFile.ExternalSource.FileID.ToString("N"));
}

this.WorkflowProcess.InfoStorage[fileIDContentSourcesAlias] = fileIDContentSources;